/*
 * Decompiled with CFR 0.152.
 */
package sum.multimedia;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import sum.ereignis.Bildschirm;

public class Ton
implements Serializable {
    private boolean zNimmtAuf = false;
    private boolean zSpieltAb = false;
    private AudioFormat hatFormat = this.getFormat();
    private ByteArrayOutputStream hatOutStream;

    private AudioFormat getFormat() {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void starteAufnahme() {
        if (!this.zSpieltAb) {
            try {
                this.hatFormat = this.getFormat();
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.hatFormat);
                final TargetDataLine line = (TargetDataLine)AudioSystem.getLine(info);
                line.open(this.hatFormat);
                line.start();
                Runnable runner = new Runnable(){
                    int bufferSize;
                    byte[] buffer;
                    {
                        this.bufferSize = (int)Ton.this.hatFormat.getSampleRate() * Ton.this.hatFormat.getFrameSize();
                        this.buffer = new byte[this.bufferSize];
                    }

                    @Override
                    public void run() {
                        Ton.this.hatOutStream = new ByteArrayOutputStream();
                        Ton.this.zNimmtAuf = true;
                        try {
                            while (Ton.this.zNimmtAuf) {
                                int count = line.read(this.buffer, 0, this.buffer.length);
                                if (count <= 0) continue;
                                Ton.this.hatOutStream.write(this.buffer, 0, count);
                            }
                            Ton.this.hatOutStream.close();
                        }
                        catch (IOException e) {
                            System.out.println("I/O problems: " + e);
                            System.exit(-1);
                        }
                    }
                };
                Thread captureThread = new Thread(runner);
                captureThread.start();
            }
            catch (LineUnavailableException e) {
                System.out.println("Line unavailable: " + e);
                System.exit(-2);
            }
        }
    }

    public void stoppeAufnahme() {
        if (this.zNimmtAuf) {
            this.zNimmtAuf = false;
        }
    }

    public boolean ladeTon(String pDatei) {
        File soundFile = new File(pDatei);
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = AudioSystem.getAudioInputStream(soundFile);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return false;
        }
        this.hatFormat = audioInputStream.getFormat();
        int bufferSize = (int)this.hatFormat.getSampleRate() * this.hatFormat.getFrameSize();
        byte[] buffer = new byte[bufferSize];
        this.hatOutStream = new ByteArrayOutputStream();
        try {
            int nBytesRead = 0;
            while (nBytesRead != -1) {
                nBytesRead = audioInputStream.read(buffer, 0, buffer.length);
                if (nBytesRead <= 0) continue;
                this.hatOutStream.write(buffer, 0, nBytesRead);
            }
            this.hatOutStream.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean ladeTon() {
        FileDialog ladendialog = new FileDialog((Frame)Bildschirm.topFenster, "Ton laden", 0);
        ladendialog.setVisible(true);
        String dateiname = ladendialog.getFile();
        if (dateiname != null) {
            String pfadname = ladendialog.getDirectory();
            return this.ladeTon(pfadname + dateiname);
        }
        return false;
    }

    public void spieleTon() {
        if (!this.zNimmtAuf && this.hatOutStream != null) {
            try {
                byte[] audio = this.hatOutStream.toByteArray();
                ByteArrayInputStream input = new ByteArrayInputStream(audio);
                final AudioInputStream ais = new AudioInputStream(input, this.hatFormat, audio.length / this.hatFormat.getFrameSize());
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.hatFormat);
                final SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(this.hatFormat);
                line.start();
                Runnable runner = new Runnable(){
                    int bufferSize;
                    byte[] buffer;
                    {
                        this.bufferSize = (int)Ton.this.hatFormat.getSampleRate() * Ton.this.hatFormat.getFrameSize();
                        this.buffer = new byte[this.bufferSize];
                    }

                    @Override
                    public void run() {
                        Ton.this.zSpieltAb = true;
                        try {
                            int count;
                            while ((count = ais.read(this.buffer, 0, this.buffer.length)) != -1 && Ton.this.zSpieltAb) {
                                if (count <= 0) continue;
                                line.write(this.buffer, 0, count);
                            }
                            if (Ton.this.zSpieltAb) {
                                line.drain();
                            }
                            Ton.this.zSpieltAb = false;
                        }
                        catch (IOException e) {
                            System.out.println("I/O problems: " + e);
                            System.exit(-3);
                        }
                    }
                };
                Thread playThread = new Thread(runner);
                playThread.start();
            }
            catch (LineUnavailableException e) {
                System.out.println("Line unavailable: " + e);
                System.exit(-4);
            }
        }
    }

    public void stoppeAbspielen() {
        if (this.zSpieltAb) {
            this.zSpieltAb = false;
        }
    }

    public boolean speichereTon(String pDatei) {
        String fileName = pDatei + ".wav";
        File outputFile = new File(fileName);
        AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
        if (!this.zNimmtAuf && !this.zSpieltAb && this.hatOutStream != null) {
            byte[] audio = this.hatOutStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(audio);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, this.hatFormat, audio.length / this.hatFormat.getFrameSize());
            try {
                AudioSystem.write(audioInputStream, targetType, outputFile);
                return true;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean speichereTon() {
        FileDialog speicherndialog = new FileDialog((Frame)Bildschirm.topFenster, "Ton speichern", 1);
        speicherndialog.setVisible(true);
        String dateiname = speicherndialog.getFile();
        if (dateiname != null) {
            String pfadname = speicherndialog.getDirectory();
            return this.speichereTon(pfadname + dateiname);
        }
        return false;
    }

    public void gibFrei() {
    }
}

