/*
 * Decompiled with CFR 0.152.
 */
package sum.strukturen;

import java.io.Serializable;
import sum.werkzeuge.Textwerkzeug;

public class Baum<Typ>
implements Serializable {
    static final long serialVersionUID = 8311777060602L;
    private Typ kenntInhalt;
    private Baum<Typ> kenntLinks;
    private Baum kenntRechts;
    private Baum<Typ> kenntVater;

    public Baum(Typ pInhalt) {
        this.kenntInhalt = pInhalt;
        this.kenntLinks = null;
        this.kenntRechts = null;
        this.kenntVater = null;
    }

    public Baum(Typ pInhalt, Baum<Typ> pLinks, Baum<Typ> pRechts) {
        this.kenntInhalt = pInhalt;
        this.kenntLinks = pLinks;
        if (pLinks != null) {
            pLinks.setzeVater(this);
        }
        this.kenntRechts = pRechts;
        if (pRechts != null) {
            pRechts.setzeVater(this);
        }
        this.kenntVater = null;
    }

    public Typ inhalt() {
        return this.kenntInhalt;
    }

    public void setzeInhalt(Typ pInhalt) {
        this.kenntInhalt = pInhalt;
    }

    public boolean istLeer() {
        return this.kenntInhalt == null;
    }

    public boolean teilbaeumeLeer() {
        return this.kenntLinks.istLeer() && this.kenntRechts.istLeer();
    }

    public Baum<Typ> linkerTeilbaum() {
        return this.kenntLinks;
    }

    public Baum<Typ> rechterTeilbaum() {
        return this.kenntRechts;
    }

    public void setzeLinkenTeilbaum(Baum<Typ> pBaum) {
        this.kenntLinks = pBaum;
        if (pBaum != null) {
            pBaum.setzeVater(this);
        }
    }

    public void setzeRechtenTeilbaum(Baum<Typ> pBaum) {
        this.kenntRechts = pBaum;
        if (pBaum != null) {
            pBaum.setzeVater(this);
        }
    }

    public boolean istBlatt() {
        return this.kenntLinks == null && this.kenntRechts == null;
    }

    public Baum<Typ> vater() {
        return this.kenntVater;
    }

    public void setzeVater(Baum<Typ> pBaum) {
        this.kenntVater = pBaum;
    }

    public boolean istWurzel() {
        return this.kenntVater == null;
    }

    public String toString() {
        Textwerkzeug lTextwerkzeug = new Textwerkzeug();
        String lString = this.baumString(0);
        if (lTextwerkzeug.laenge(lString) > 0) {
            lString = lTextwerkzeug.textOhne(lString, lTextwerkzeug.laenge(lString), lTextwerkzeug.laenge(lString));
        }
        return lString;
    }

    private String baumString(int pTiefe) {
        String lString = "";
        String lPunkte = "";
        for (int i = 1; i <= pTiefe; ++i) {
            lPunkte = lPunkte + ".";
        }
        if (this.kenntLinks != null) {
            lString = lString + super.baumString(pTiefe + 1);
        }
        lString = this.kenntInhalt == null ? lString + lPunkte + "leer\n" : lString + lPunkte + this.kenntInhalt.toString() + "\n";
        if (this.kenntRechts != null) {
            lString = lString + this.kenntRechts.baumString(pTiefe + 1);
        }
        return lString;
    }
}

