/*
 * Decompiled with CFR 0.152.
 */
package sum.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import sum.sql.SQLErgebnisliste;

public class Datenbank {
    public static Connection hatVerbindung;
    private String hatProduktDaten;
    private String fehler = "SQL-Fehler!";
    private SQLErgebnisliste hatErgebnis;

    public Datenbank() {
        hatVerbindung = null;
        this.hatErgebnis = null;
    }

    private String transaktionsStatus() {
        try {
            int action = hatVerbindung.getTransactionIsolation();
            switch (action) {
                case 0: {
                    return "TRANSACTION_NONE ";
                }
                case 1: {
                    return "TRANSACTION_READ_COMMITTED ";
                }
                case 2: {
                    return "TRANSACTION_READ_UNCOMMITTED ";
                }
                case 3: {
                    return "TRANSACTION_REPEATABLE_READ  ";
                }
                case 4: {
                    return "TRANSACTION_SERIALIZABLE  ";
                }
            }
            return "Nicht definiert";
        }
        catch (SQLException e) {
            System.out.println(this.fehler);
            System.out.println("Datenbank Transaktionsstatus: " + e);
            return "DB-Fehler";
        }
    }

    public String verbinde(String pDatenbank, String pTreiber, String pAnbindung, String pUser, String pPwd) {
        String lTreiber = pTreiber;
        try {
            Class.forName(lTreiber);
            hatVerbindung = DriverManager.getConnection(pAnbindung + pDatenbank, pUser, pPwd);
            this.hatProduktDaten = "Produkt: " + hatVerbindung.getMetaData().getDatabaseProductName() + " Version: " + hatVerbindung.getMetaData().getDatabaseProductVersion();
            return "";
        }
        catch (Exception e) {
            System.out.println(this.fehler);
            System.out.println("Datenbank verbinden: " + e.toString());
            return "DB-Fehler: " + e.toString();
        }
    }

    public String verbindeMySQL(String pDatenbank, String pServer, String pUser, String pPwd) {
        return this.verbinde(pDatenbank, "com.mysql.jdbc.Driver", "jdbc:mysql://" + pServer + "/", pUser, pPwd);
    }

    public void trenne() {
        try {
            hatVerbindung.close();
        }
        catch (SQLException e) {
            System.out.println(this.fehler);
            System.out.println("Datenbank trennen: " + e.toString());
        }
    }

    public int tabellenanzahl() {
        try {
            int lAnzahl = 0;
            ResultSet tab = hatVerbindung.getMetaData().getTables(null, null, null, null);
            while (tab.next()) {
                if (!tab.getString("Table_Type").equals("TABLE")) continue;
                ++lAnzahl;
            }
            tab = null;
            return lAnzahl;
        }
        catch (SQLException e) {
            System.out.println("Datenbanktabellen: " + e);
            return -1;
        }
    }

    public String tabellenname(int pNummer) {
        try {
            int lAnzahl = 0;
            String lName = "";
            ResultSet tab = hatVerbindung.getMetaData().getTables(null, null, null, null);
            while (tab.next()) {
                if (!tab.getString("Table_Type").equals("TABLE") || ++lAnzahl != pNummer) continue;
                lName = tab.getString("Table_Name");
            }
            tab = null;
            return lName;
        }
        catch (SQLException e) {
            System.out.println("Datenbanktabellen: " + e);
            return "Keine Tabelle";
        }
    }

    public String datenbankinfo() {
        try {
            String c = hatVerbindung.getAutoCommit() ? "AUTO-COMMIT" : "KEIN AUTO-COMMIT";
            return this.hatProduktDaten + "\n" + "Status: " + this.transaktionsStatus() + "\n" + "Commit: " + c + "\n" + "User: " + hatVerbindung.getMetaData().getUserName();
        }
        catch (SQLException e) {
            System.out.println(this.fehler);
            System.out.println("DatenbankInfo: " + e.toString());
            return "DB-Fehler: " + e.toString();
        }
    }

    public String sendeSQL(String pSQLAnweisung) {
        if (this.hatErgebnis != null) {
            this.hatErgebnis.gibFrei();
        }
        this.hatErgebnis = new SQLErgebnisliste(this, pSQLAnweisung);
        if (this.hatErgebnis != null) {
            return "";
        }
        System.out.println("sendeSQL: " + this.fehler);
        return this.fehler;
    }

    public SQLErgebnisliste ergebnis() {
        return this.hatErgebnis;
    }
}

