/*
 * Decompiled with CFR 0.152.
 */
package sum.akzeptor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import sum.akzeptor.FiniteStateAutomaton;
import sum.akzeptor.FsaDisplay;
import sum.akzeptor.Guide;
import sum.akzeptor.Location;
import sum.akzeptor.Tourist;

class Tracer
implements Tourist {
    Point center;
    int rad = 6;
    int size = 2 * this.rad + 1;
    int state;
    Guide guide;
    Location location;
    String string;
    int currentChar;
    FsaDisplay display;
    FiniteStateAutomaton fsa;

    public void tour() {
        switch (this.state) {
            default: {
                break;
            }
            case 1: {
                if (this.currentChar < this.string.length()) {
                    this.location.handleTourist(this);
                    this.state = 0;
                } else {
                    this.state = this.location.isGoal() ? 2 : 3;
                    return;
                }
            }
            case 0: {
                if (this.guide != null) {
                    this.setPosition(this.guide.nextPosition());
                    break;
                }
                this.state = 3;
            }
        }
    }

    public void setDisplay() {
        this.display.setString(this.string, this.currentChar + 1);
    }

    public int getState() {
        return this.state;
    }

    void paint(Graphics g) {
        if (this.center == null) {
            return;
        }
        switch (this.state) {
            case 1: {
                g.setColor(Color.red);
                break;
            }
            case 0: 
            case 4: {
                g.setColor(Color.green);
                break;
            }
            case 2: {
                g.setColor(Color.blue);
                break;
            }
            case 3: {
                g.setColor(Color.gray);
            }
        }
        g.fillOval(this.center.x - this.rad + 1, this.center.y - this.rad + 1, this.size, this.size);
        g.setColor(Color.black);
    }

    public void guideFinished() {
        this.state = 1;
        this.display.advance();
    }

    public void setString(String string) {
        this.string = string;
    }

    public char payToll(boolean advance) {
        char toll = 'A';
        if (this.currentChar < this.string.length()) {
            toll = this.string.charAt(this.currentChar);
            ++this.currentChar;
        }
        return toll;
    }

    public void setGuide(Guide newGuide) {
        this.guide = newGuide;
        this.fsa.repaint();
        if (this.state != 2 && this.state != 3) {
            this.state = this.guide == null ? 3 : 1;
        }
    }

    public Tourist copy() {
        Tracer t = new Tracer(this.fsa, this.display);
        t.center = new Point(this.center.x, this.center.y);
        t.guide = this.guide;
        t.location = this.location;
        t.state = this.state;
        t.string = this.string;
        t.currentChar = this.currentChar;
        return t;
    }

    public Point getPosition() {
        return this.center;
    }

    public void setPosition(Point p) {
        this.center = new Point(p.x, p.y);
    }

    Tracer(FiniteStateAutomaton fsa, FsaDisplay fd) {
        this.display = fd;
        this.fsa = fsa;
        this.location = null;
        this.guide = null;
        this.state = 1;
        this.currentChar = 0;
    }

    public char currentSymbol() {
        if (this.currentChar < this.string.length()) {
            return this.string.charAt(this.currentChar);
        }
        return 'A';
    }

    Tracer(Point startPosition, String string) {
        this.center = startPosition;
        this.location = null;
        this.guide = null;
        this.string = string;
        this.currentChar = 0;
        this.state = 4;
    }

    void clear() {
        if (this.guide != null) {
            this.guide = null;
        }
        if (this.location != null) {
            this.location = null;
        }
        this.center = null;
        this.string = null;
        this.currentChar = 0;
        this.state = 1;
    }

    public void setLocation(Location l) {
        this.location = l;
    }
}

