/*
 * Decompiled with CFR 0.152.
 */
package sum.akzeptor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import sum.akzeptor.Child;
import sum.akzeptor.Metric;
import sum.akzeptor.Part;
import sum.akzeptor.Rule;
import sum.akzeptor.Side;

public class RuleBasedLayout
implements LayoutManager {
    protected Child listChild;
    protected Rule listRule;
    public Insets margin;
    public Point spacing;
    protected int[] oppositeSide = new int[]{2, 3, 0, 1};
    protected int[] unknownMetricStretch = new int[]{4, 5, 4, 5, 2, 3};

    public void setMargins(int i, int j, int k, int l) {
        this.margin = new Insets(j, i, l, k);
    }

    public void setMinimumSpacing(int i, int j) {
        this.spacing = new Point(i, j);
    }

    public Side left(Component component) {
        return new Side(0, component);
    }

    public Side top(Component component) {
        return new Side(1, component);
    }

    public Side right(Component component) {
        return new Side(2, component);
    }

    public Side bottom(Component component) {
        return new Side(3, component);
    }

    public Metric width(Component component) {
        return new Metric(4, component);
    }

    public Metric percentWidthOf(Component component, int i) {
        return new Metric(i, 4, component);
    }

    public Metric height(Component component) {
        return new Metric(5, component);
    }

    public Metric percentHeightOf(Component component, int i) {
        return new Metric(i, 5, component);
    }

    public Part part(Component component) {
        return new Part(component);
    }

    protected void addRule(Rule rule) {
        rule.next = this.listRule;
        this.listRule = rule;
    }

    public void move(Side side, Metric metric, int i) {
        this.addRule(new Rule(3, side, metric, i));
    }

    protected int defaultSpacing(int i) {
        switch (i) {
            case 0: {
                return this.spacing.x;
            }
            case 1: {
                return this.spacing.y;
            }
            case 2: {
                return -this.spacing.x;
            }
            case 3: {
                return -this.spacing.y;
            }
        }
        return 0;
    }

    public void move(Side side, Metric metric) {
        int i = 0;
        if (side.component.getParent() != metric.component && metric.metric != side.metric) {
            i = this.defaultSpacing(side.metric);
        }
        this.move(side, metric, i);
    }

    protected void relLast(Component component, int i, int j) {
        Component component1 = this.listRule != null ? this.listRule.actOn.component : null;
        this.addRule(new Rule(3, new Side(this.oppositeSide[i], component), new Side(this.listRule != null ? i : this.oppositeSide[i], component1), j));
    }

    public void belowLast(Component component, int i) {
        this.relLast(component, 3, i);
    }

    public void belowLast(Component component) {
        this.belowLast(component, this.defaultSpacing(1));
    }

    public void aboveLast(Component component, int i) {
        this.relLast(component, 1, i);
    }

    public void aboveLast(Component component) {
        this.aboveLast(component, this.defaultSpacing(3));
    }

    public void rightOfLast(Component component, int i) {
        this.relLast(component, 2, i);
    }

    public void rightOfLast(Component component) {
        this.rightOfLast(component, this.defaultSpacing(0));
    }

    public void leftOfLast(Component component, int i) {
        this.relLast(component, 0, i);
    }

    public void leftOfLast(Component component) {
        this.leftOfLast(component, this.defaultSpacing(2));
    }

    public void stretch(Metric metric, Metric metric1, int i) {
        this.addRule(new Rule(2, metric, metric1, i));
    }

    public void stretch(Metric metric, Metric metric1) {
        int i = 0;
        if (metric.component.getParent() != metric1.component && metric1.metric != metric.metric) {
            i = this.defaultSpacing(metric.metric);
        }
        this.stretch(metric, metric1, i);
    }

    public void vcenter(Part part1, Part part2, int i) {
        this.addRule(new Rule(1, part1, part2, i));
    }

    public void vcenter(Part part1, Part part2) {
        this.vcenter(part1, part2, 0);
    }

    public void hcenter(Part part1, Part part2, int i) {
        this.addRule(new Rule(0, part1, part2, i));
    }

    public void hcenter(Part part1, Part part2) {
        this.hcenter(part1, part2, 0);
    }

    protected Child findChild(Component component) {
        Child child = this.listChild;
        while (child != null) {
            if (child.component == component) {
                child.solve();
                return child;
            }
            child = child.next;
        }
        return null;
    }

    protected void markUnknowns() {
        Rule rule = this.listRule;
        while (rule != null) {
            Child child = this.findChild(rule.actOn.component);
            switch (rule.action) {
                case 2: {
                    Metric metric = (Metric)rule.actOn;
                    child.known[metric.metric] = false;
                    child.known[this.unknownMetricStretch[metric.metric]] = false;
                    break;
                }
                case 3: {
                    Side side = (Side)rule.actOn;
                    child.known[side.side] = false;
                    child.known[this.oppositeSide[side.side]] = false;
                    break;
                }
                case 0: 
                case 1: {
                    child.known[rule.action] = false;
                    child.known[rule.action + 2] = false;
                    break;
                }
            }
            rule = rule.next;
        }
    }

    protected boolean applyRule(Rule rule) {
        Child child = this.findChild(rule.relTo.component);
        Child child1 = this.findChild(rule.actOn.component);
        if (rule.action == 2 || rule.action == 3) {
            Metric metric = (Metric)rule.actOn;
            Metric metric1 = (Metric)rule.relTo;
            if (!child.known[metric1.metric]) {
                return false;
            }
            int k = child.metric[metric1.metric];
            if (metric1.metric == 4 || metric1.metric == 5) {
                k = k * metric1.percent / 100;
            }
            child1.metric[metric.metric] = k + rule.offset;
            child1.known[metric.metric] = true;
        } else {
            int i = rule.action;
            int j = rule.action + 4;
            if (!(child.known[i] && child.known[j] && child1.known[j])) {
                return false;
            }
            child1.metric[i] = child.metric[i] + (child.metric[j] - child1.metric[j]) / 2 + rule.offset;
            child1.known[i] = true;
        }
        child1.solve();
        rule.applied = true;
        return true;
    }

    protected boolean applyRules(Container container) {
        int k;
        int j;
        this.markUnknowns();
        Rule rule = this.listRule;
        while (rule != null) {
            if (rule.relTo.component == null) {
                rule.relTo.component = container;
            }
            rule.applied = false;
            rule = rule.next;
        }
        int i = 0;
        do {
            j = 0;
            k = 0;
            Rule rule1 = this.listRule;
            while (rule1 != null) {
                if (!rule1.applied && this.applyRule(rule1)) {
                    ++j;
                    ++i;
                }
                rule1 = rule1.next;
                ++k;
            }
        } while (j > 0);
        return k == i;
    }

    public void setParent(Container container) {
        container.setLayout(this);
        container.resize(0, 0);
        container.show();
        Dimension dimension = this.minimumLayoutSize(container);
        container.resize(dimension.width, dimension.height);
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = container.size();
        int[] ai = new int[]{16, 16};
        while (!this.layoutContainer(container, false, ai[0], ai[1])) {
            ai[0] = ai[0] * 2;
            ai[1] = ai[1] * 2;
        }
        int j = 0;
        while (j < 2) {
            while (this.layoutContainer(container, false, ai[0], ai[1])) {
                int n = j;
                ai[n] = ai[n] / 2;
            }
            int i = (ai[j] * 2 - ai[j]) / 2;
            do {
                boolean flag;
                if (flag = this.layoutContainer(container, false, j != 0 ? ai[0] : ai[0] + i, j != 1 ? ai[1] : ai[1] + i)) {
                    i /= 2;
                    continue;
                }
                int n = j;
                ai[n] = ai[n] + i;
            } while (i != 0);
            int n = j++;
            ai[n] = ai[n] + 1;
        }
        if (ai[0] > dimension.width || ai[1] > dimension.height) {
            return new Dimension(ai[0], ai[1]);
        }
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void addLayoutComponent(String s, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        this.layoutContainer(container, true, container.size().width, container.size().height);
    }

    public boolean layoutContainer(Container container, boolean flag, int i, int j) {
        Insets insets = container.insets();
        if (this.listChild == null) {
            int k = container.countComponents();
            for (int l = 0; l < k; ++l) {
                Component component = container.getComponent(l);
                Point point = component.location();
                point.x += insets.left + this.margin.left;
                point.y += insets.top + this.margin.top;
                Dimension dimension = component.preferredSize();
                Child child = new Child(component, dimension, point.x, point.y, dimension.width, dimension.height);
                child.next = this.listChild;
                this.listChild = child;
            }
            Child child1 = new Child(container, null, 0, 0, 0, 0);
            child1.next = this.listChild;
            this.listChild = child1;
        }
        if (this.listChild == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle(insets.left + this.margin.left, insets.top + this.margin.top, i - insets.left - insets.right - this.margin.left - this.margin.right, j - insets.bottom - insets.top - this.margin.bottom - this.margin.top);
        this.listChild.setMetrics(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this.applyRules(container)) {
            return false;
        }
        Child child2 = this.listChild.next;
        while (child2 != null) {
            if (!child2.check()) {
                return false;
            }
            int i1 = child2.metric[0];
            int j1 = child2.metric[1];
            int k1 = child2.metric[4];
            int l1 = child2.metric[5];
            if (flag) {
                child2.component.move(i1, j1);
                child2.component.resize(k1, l1);
            } else {
                if (k1 < child2.preferredSize.width) {
                    return false;
                }
                if (l1 < child2.preferredSize.height) {
                    return false;
                }
                ++rectangle.width;
                ++rectangle.height;
                if (!rectangle.inside(i1, j1) || !rectangle.inside(i1 + k1, j1 + l1)) {
                    return false;
                }
                Rectangle rectangle1 = new Rectangle(i1, j1, k1, l1);
                rectangle1.grow(this.spacing.x - 1, this.spacing.y - 1);
                Child child3 = this.listChild.next;
                while (child3 != null) {
                    Rectangle rectangle2;
                    if (child3 != child2 && rectangle1.intersects(rectangle2 = new Rectangle(child3.metric[0], child3.metric[1], child3.metric[4], child3.metric[5]))) {
                        return false;
                    }
                    child3 = child3.next;
                }
            }
            child2 = child2.next;
        }
        return true;
    }

    public RuleBasedLayout() {
        this.margin = new Insets(8, 8, 8, 8);
        this.spacing = new Point(8, 8);
    }
}

