/*
 * Decompiled with CFR 0.152.
 */
package sum.akzeptor;

import java.awt.Point;

class Direction {
    double x_dir;
    double y_dir;
    static final double pi = Math.PI;
    static final double twoPi = Math.PI * 2;

    double getAngleInDegrees() {
        double angle = this.getAngle();
        return angle * 57.29577951308232;
    }

    void set(int x1, int y1, int x2, int y2) {
        double length = 0.0;
        double x_length = x2 - x1;
        double y_length = y2 - y1;
        length = Math.sqrt(x_length * x_length + y_length * y_length);
        this.x_dir = x_length / length;
        this.y_dir = y_length / length;
    }

    void set(Point p1, int x2, int y2) {
        this.set(p1.x, p1.y, x2, y2);
    }

    void set(Point p1, Point p2) {
        this.set(p1.x, p1.y, p2.x, p2.y);
    }

    void set(double angle) {
        this.x_dir = Math.cos(angle);
        this.y_dir = Math.sin(angle);
    }

    public String toString() {
        return new String("Direction - x_dir: " + this.x_dir + " y_dir: " + this.y_dir);
    }

    void rotate(double radians, Direction d) {
        double angle = this.getAngle();
        if (Math.abs(radians) > Math.PI * 2) {
            radians = Math.IEEEremainder(radians, Math.PI * 2) * (Math.PI * 2);
        }
        if ((angle += radians) > Math.PI * 2) {
            angle -= Math.PI * 2;
        } else if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        d.set(angle);
    }

    Direction rotate(double radians) {
        double angle = this.getAngle();
        if (Math.abs(radians) > Math.PI * 2) {
            radians = Math.IEEEremainder(radians, Math.PI * 2) * (Math.PI * 2);
        }
        if ((angle += radians) > Math.PI * 2) {
            angle -= Math.PI * 2;
        } else if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        return new Direction(angle);
    }

    int xOffset(int length) {
        return (int)Math.round((double)length * this.x_dir);
    }

    double getAngle() {
        double angle = Math.acos(this.x_dir);
        if (Math.asin(this.y_dir) < 0.0) {
            angle = angle >= 1.5707963267948966 ? (angle += Math.PI - 2.0 * (angle - 1.5707963267948966)) : Math.PI * 2 - angle;
        }
        return angle;
    }

    Direction(int x1, int y1, int x2, int y2) {
        this.set(x1, y1, x2, y2);
    }

    Direction(Point p1, Point p2) {
        this.set(p1.x, p1.y, p2.x, p2.y);
    }

    Direction(Point p1, int x2, int y2) {
        this.set(p1.x, p1.y, x2, y2);
    }

    Direction(double angle) {
        this.set(angle);
    }

    private Direction(double xd, double yd) {
        this.x_dir = xd;
        this.y_dir = yd;
    }

    Point getOffset(int length) {
        return new Point((int)Math.round((double)length * this.x_dir), (int)Math.round((double)length * this.y_dir));
    }

    int yOffset(int length) {
        return (int)Math.round((double)length * this.y_dir);
    }

    void translatePoint(Point p, int distance) {
        p.translate(this.xOffset(distance), this.yOffset(distance));
    }
}

