/*
 * Decompiled with CFR 0.152.
 */
package sum.generator;

import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.BlueJ;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import sum.generator.KomponentenBeschreibung;
import sum.generator.KomponentenListe;
import sum.generator.KomponentenModell;
import sum.generator.SuMGeneratorAnwendung;
import sum.werkzeuge.Uhr;

public class Schreiber {
    public static final String METHODE = "//    Schreiben Sie hier den Text ihres Dienstes";
    public static final String A1 = "    ";
    public static final String A2 = "        ";
    public static final String A3 = "            ";
    public static final String K1 = "/**";
    public static final String K2 = " * ";
    public static final String K3 = " */";
    public static final String K4 = "//";
    public static final char N = '\n';
    private Uhr hatUhr;
    private BlueJ kenntBlueJ;
    private SuMGeneratorAnwendung kenntAnwendung;

    public Schreiber(BlueJ pBlueJ, SuMGeneratorAnwendung pAnwendung) {
        this.kenntBlueJ = pBlueJ;
        this.kenntAnwendung = pAnwendung;
        this.hatUhr = new Uhr();
    }

    public void schreibe(KomponentenListe pListe, File pVerzeichnis) {
        if (this.kenntBlueJ != null) {
            BProject blueJProject = this.kenntBlueJ.newProject(pVerzeichnis);
            this.schreibeXML(pListe, pVerzeichnis);
            this.schreibeSuMProgramm(pVerzeichnis);
            this.schreibeSuMApplet(pVerzeichnis);
            this.schreibeSuMAnwendung(pListe, pVerzeichnis);
            try {
                BPackage[] packageFeld = blueJProject.getPackages();
                BPackage blueJPackage = packageFeld[0];
                blueJPackage.reload();
            }
            catch (ProjectNotOpenException e) {
                System.out.println("Package-Problem: " + e.toString());
            }
            catch (PackageNotFoundException e) {
                System.out.println("Package-Problem: " + e.toString());
            }
        } else {
            pVerzeichnis.mkdir();
            this.schreibeXML(pListe, pVerzeichnis);
            this.schreibeSuMProgramm(pVerzeichnis);
            this.schreibeSuMApplet(pVerzeichnis);
            this.schreibeSuMAnwendung(pListe, pVerzeichnis);
        }
    }

    public void schreibeSuMProgramm(File pVerzeichnis) {
        OutputStreamWriter lOutputStreamWriter;
        try {
            lOutputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(pVerzeichnis, "SuMProgramm.java")), "UTF-8");
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
        try {
            lOutputStreamWriter.write("public class SuMProgramm\n");
            lOutputStreamWriter.write("{\n");
            lOutputStreamWriter.write("    public static void main(String args[])\n");
            lOutputStreamWriter.write("    {\n");
            lOutputStreamWriter.write(A2 + this.kenntAnwendung.name() + " hat" + this.kenntAnwendung.name() + " = new " + this.kenntAnwendung.name() + "();" + '\n');
            lOutputStreamWriter.write("        hat" + this.kenntAnwendung.name() + ".fuehreAus();" + '\n');
            lOutputStreamWriter.write("    }\n\n");
            lOutputStreamWriter.write("}\n");
            lOutputStreamWriter.close();
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
    }

    public void schreibeSuMApplet(File pVerzeichnis) {
        OutputStreamWriter lOutputStreamWriter;
        try {
            lOutputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(pVerzeichnis, "SuMApplet.java")), "UTF-8");
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
        try {
            lOutputStreamWriter.write("import java.awt.*;\n");
            lOutputStreamWriter.write("import java.awt.event.*;\n");
            lOutputStreamWriter.write("import java.applet.Applet;\n\n");
            lOutputStreamWriter.write("public class SuMApplet extends Applet\n");
            lOutputStreamWriter.write("{\n");
            lOutputStreamWriter.write("    public SuMApplet()\n");
            lOutputStreamWriter.write("    {\n");
            lOutputStreamWriter.write(A2 + this.kenntAnwendung.name() + " hat" + this.kenntAnwendung.name() + " = new " + this.kenntAnwendung.name() + "();" + '\n');
            lOutputStreamWriter.write("        hat" + this.kenntAnwendung.name() + ".fuehreAus();" + '\n');
            lOutputStreamWriter.write("    }\n\n");
            lOutputStreamWriter.write("}\n");
            lOutputStreamWriter.close();
        }
        catch (IOException e) {
            throw new Error("Fehler: " + e.toString());
        }
    }

    public void schreibeSuMAnwendung(KomponentenListe pListe, File pVerzeichnis) {
        OutputStreamWriter lOutputStreamWriter;
        try {
            lOutputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(pVerzeichnis, this.kenntAnwendung.name() + ".java")), "UTF-8");
        }
        catch (IOException ex) {
            throw new Error("IO Error");
        }
        try {
            KomponentenModell lKomponente;
            int i;
            lOutputStreamWriter.write("/**\n");
            lOutputStreamWriter.write(" * Die Klasse " + this.kenntAnwendung.name() + " wurde automatisch erstellt: " + '\n');
            lOutputStreamWriter.write(" * \n");
            lOutputStreamWriter.write(" * @author \n");
            lOutputStreamWriter.write(" * @version " + this.hatUhr.datum() + '\n');
            lOutputStreamWriter.write(" */\n\n");
            lOutputStreamWriter.write("import sum.komponenten.*;\n");
            lOutputStreamWriter.write("import sum.werkzeuge.*;\n");
            lOutputStreamWriter.write("import sum.ereignis.*;\n\n");
            lOutputStreamWriter.write("public class " + this.kenntAnwendung.name() + " extends EBAnwendung" + '\n');
            lOutputStreamWriter.write("{\n");
            lOutputStreamWriter.write("    // Objekte\n");
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lOutputStreamWriter.write(lKomponente.objektText());
            }
            lOutputStreamWriter.write(10);
            lOutputStreamWriter.write("    // Attribute\n\n");
            lOutputStreamWriter.write(Schreiber.kommentarText("Konstruktor"));
            lOutputStreamWriter.write("    public " + this.kenntAnwendung.name() + "()" + '\n');
            lOutputStreamWriter.write("    {\n");
            lOutputStreamWriter.write("        //Initialisierung der Oberklasse\n");
            lOutputStreamWriter.write("        super(" + (this.kenntAnwendung.bildschirm().breite() - 185) + ", " + this.kenntAnwendung.bildschirm().hoehe() + ");" + '\n' + '\n');
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lOutputStreamWriter.write(lKomponente.initText());
            }
            lOutputStreamWriter.write("    }\n\n");
            for (i = 0; i < pListe.groesse(); ++i) {
                lKomponente = pListe.komponenteAn(i);
                lOutputStreamWriter.write(lKomponente.ereignisText());
            }
            lOutputStreamWriter.write("}\n");
            lOutputStreamWriter.close();
        }
        catch (IOException ex) {
            throw new Error("IO Error");
        }
    }

    public void schreibeXML(KomponentenListe pListe, File pVerzeichnis) {
        try {
            XStream lXStream = new XStream();
            ObjectOutputStream lEncoder = lXStream.createObjectOutputStream(new FileWriter(new File(pVerzeichnis, "SuMGenerator.xml")));
            Vector<Object> lListe = new Vector<Object>();
            lListe.addElement(this.kenntAnwendung.name());
            for (int i = 0; i < pListe.groesse(); ++i) {
                KomponentenModell lKomponente = pListe.komponenteAn(i);
                KomponentenBeschreibung lBeschreibung = new KomponentenBeschreibung(lKomponente);
                lListe.addElement(lBeschreibung);
            }
            lEncoder.writeObject(lListe);
            lEncoder.close();
        }
        catch (IOException ex) {
            throw new Error(ex.toString());
        }
    }

    public void lese(KomponentenListe pListe, File pDatei) {
        try {
            XStream lXStream = new XStream();
            ObjectInputStream lDecoder = lXStream.createObjectInputStream(new BufferedReader(new FileReader(pDatei)));
            Vector lListe = (Vector)lDecoder.readObject();
            this.kenntAnwendung.setzeName((String)lListe.firstElement());
            for (int i = 1; i < lListe.size(); ++i) {
                KomponentenBeschreibung lBeschreibung = (KomponentenBeschreibung)lListe.elementAt(i);
                KomponentenModell lKomponente = lBeschreibung.komponente();
                pListe.neueKomponente(lKomponente);
            }
            lDecoder.close();
        }
        catch (Exception ex) {
            throw new Error(ex.toString());
        }
    }

    public static String kommentarText(String pKommentar) {
        String lText = "/**\n * " + pKommentar + '\n' + K3 + '\n';
        return lText;
    }

    public static String methodenText(String pMethodenName) {
        String lText = "    public void " + pMethodenName + '\n' + A1 + "{" + '\n' + A2 + METHODE + '\n' + A1 + "}" + '\n' + '\n';
        return lText;
    }
}

