/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import sum.transduktor.FSA;

public class FsaDisplay
extends Canvas {
    Font f;
    FontMetrics fm;
    Point boxCorner;
    int boxHeight;
    int boxWidth;
    int soundIndex;
    Image offscreen;
    FSA ioManager;
    Graphics offg;
    String string;
    int charPosition;
    int pixelPosition;

    public FsaDisplay(FSA ioma) {
        this.ioManager = ioma;
        this.f = new Font("Courier", 0, 12);
        this.setFont(this.f);
        this.fm = this.getFontMetrics(this.f);
        this.string = "";
        this.charPosition = 0;
        this.pixelPosition = 0;
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        if (this.offscreen == null) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offg = this.offscreen.getGraphics();
            this.boxWidth = this.fm.charWidth('a');
            this.boxHeight = this.fm.getHeight();
        }
        Insets i = this.getParent().insets();
        this.boxCorner = new Point(d.width / 2 - this.boxWidth / 2, i.top / 2);
        this.offg.setColor(this.getBackground());
        this.offg.fillRect(0, 0, d.width, d.height);
        this.offg.setColor(Color.red);
        int hposition = this.boxCorner.x + this.boxWidth - this.pixelPosition;
        for (int j = 0; j < this.string.length(); ++j) {
            this.offg.drawString(this.string.substring(j, j + 1), hposition, this.fm.getAscent() + i.top / 2);
            hposition += this.fm.charWidth(this.string.charAt(j));
        }
        this.offg.setColor(Color.black);
        this.offg.drawRect(this.boxCorner.x, this.boxCorner.y, this.boxWidth, this.boxHeight);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    void setString(String s) {
        this.setString(s, 0);
    }

    void setString(String s, int position) {
        this.string = s + " ";
        this.charPosition = position;
        this.pixelPosition = this.fm.charWidth(this.string.charAt(0)) * position;
        this.repaint();
    }

    public void advance() {
        if (this.charPosition >= this.string.length()) {
            return;
        }
        int charWidth = this.fm.charWidth(this.string.charAt(0));
        for (int i = 0; i < charWidth; ++i) {
            ++this.pixelPosition;
            this.repaint();
            try {
                Thread.sleep(15L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.charPosition;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public Dimension preferredSize() {
        return new Dimension(super.preferredSize().width, this.fm.getHeight() + 2);
    }

    void clear() {
        this.setString("", 0);
    }
}

