/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import sum.transduktor.Direction;
import sum.transduktor.Edge;
import sum.transduktor.ExecutionControl;
import sum.transduktor.FSA;
import sum.transduktor.FsaDisplay;
import sum.transduktor.FsaEditListener;
import sum.transduktor.FsaOutput;
import sum.transduktor.FsaRunStates;
import sum.transduktor.NoEdgeSelectedException;
import sum.transduktor.NoNodeSelectedException;
import sum.transduktor.Node;
import sum.transduktor.Tourist;
import sum.transduktor.TouristManager;
import sum.transduktor.Tracer;

public class FiniteStateAutomaton
extends Canvas
implements FsaRunStates {
    protected Vector fsaListeners;
    FSA ioManager;
    TouristManager tm;
    Thread tmThread;
    Vector initialStates;
    Vector nodes;
    Vector edges;
    Vector tracers;
    Vector newTracers;
    Tracer selectedTracer;
    Image offscreen;
    Image staticImage;
    int mode;
    Node selectedNode;
    Node tempNode;
    Point po;
    Edge selectedEdge;
    Edge tempEdge;
    double angleOffset;
    FsaDisplay display;
    FsaOutput output;
    ExecutionControl control;
    String runString;
    protected int x;
    protected int y;
    Direction dir = new Direction(0, 0, 0, 0);
    static final int EDIT_MODE = 0;
    static final int NEW_EDGE = 1;
    static final int MOVE_NODE = 2;
    static final int NEW_NODE = 3;
    static final int MOVE_EDGE = 4;
    static final int RUN_STATE = 5;
    public static final int NODE_SELECTED = 0;
    public static final int EDGE_SELECTED = 1;
    public static final int NOTHING_SELECTED = 2;

    public synchronized void removeFsaEditListener(FsaEditListener fel) {
        this.fsaListeners.removeElement(fel);
    }

    Image screenImage() {
        return this.offscreen;
    }

    public void setControl(ExecutionControl ec) {
        this.control = ec;
    }

    void setup() {
        Enumeration initStates = this.initialStates.elements();
        this.tracers.removeAllElements();
        this.newTracers.removeAllElements();
        this.selectedTracer = null;
        while (initStates.hasMoreElements()) {
            Tracer t = new Tracer(this, this.display, this.output);
            t.setString(this.runString);
            Node initialState = (Node)initStates.nextElement();
            t.setLocation(initialState);
            t.setPosition(initialState.getPosition());
            this.tracers.addElement(t);
        }
        ((Tracer)this.tracers.firstElement()).setDisplay();
        this.repaint();
    }

    void addInitialState(Node n) {
        if (n != null) {
            this.initialStates.addElement(n);
        }
    }

    void enterEditState() {
        this.mode = 0;
        this.tracers.removeAllElements();
        this.enteredEditState();
        if (this.display != null) {
            this.display.setString("");
        }
        this.repaint();
    }

    public void setSelectedNodeSymbol(int i) throws NoNodeSelectedException {
        if (this.selectedNode == null) {
            throw new NoNodeSelectedException();
        }
        this.selectedNode.setSelectedSymbolIndex(i);
        this.repaint();
    }

    public void setSelectedNodeInitialState(boolean b) throws NoNodeSelectedException {
        if (this.selectedNode == null) {
            throw new NoNodeSelectedException();
        }
        if (b && !this.initialStates.isEmpty()) {
            ((Node)this.initialStates.firstElement()).setInitialState(false);
        }
        this.selectedNode.setInitialState(b);
        this.repaint();
        this.selectedNodeInitialChanged(b);
    }

    public boolean isSelectedEdgeSymbolSet(int index) throws NoEdgeSelectedException {
        if (this.selectedEdge == null) {
            throw new NoEdgeSelectedException();
        }
        return this.selectedEdge.isSymbolSet(index);
    }

    void add(Node n) {
        if (n.isInitialState()) {
            this.addInitialState(n);
        }
        this.nodes.addElement(n);
        n.setParent(this);
    }

    void add(Edge e) {
        this.edges.addElement(e);
    }

    void add(Tourist t) {
        if (t != null && !this.tracers.contains(t)) {
            this.newTracers.addElement(t);
        }
    }

    void setString(String s) {
        this.runString = s;
        this.tm.reset();
    }

    void selectedNodeInitialChanged(boolean b) {
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            ((FsaEditListener)e.nextElement()).fsaSelectedNodeInitialChanged(b);
        }
    }

    void repaintTracer() {
        this.repaint();
    }

    public FiniteStateAutomaton(FSA ioma, FsaDisplay fd, FsaOutput fo) {
        this.ioManager = ioma;
        this.fsaListeners = new Vector();
        this.control = null;
        this.display = fd;
        this.output = fo;
        this.tm = new TouristManager(this);
        this.nodes = new Vector();
        this.edges = new Vector();
        this.tracers = new Vector();
        this.newTracers = new Vector();
        this.selectedTracer = null;
        this.initialStates = new Vector();
        this.mode = 0;
        this.po = new Point(0, 0);
        this.tempNode = new Node();
        this.tempNode.setParent(this);
    }

    void select(Tourist t) {
        this.selectedTracer = (Tracer)t;
    }

    int indexOf(Node n) {
        return this.nodes.indexOf(n);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void enterRunState(String string) {
        Dimension d = this.size();
        if (this.selectedNode != null) {
            this.selectedNode.setHighlight(false);
            this.selectedNode = null;
        } else if (this.selectedEdge != null) {
            this.selectedEdge.setHighlight(false);
            this.selectedEdge = null;
        }
        this.runString = string;
        this.tm.reset();
        this.staticImage = this.createImage(d.width, d.height);
        this.paint(this.staticImage.getGraphics());
        this.mode = 5;
        this.enteredRunState();
    }

    public int[] getSelectedEdgeSymbols() throws NoEdgeSelectedException {
        if (this.selectedEdge == null) {
            throw new NoEdgeSelectedException();
        }
        return this.selectedEdge.getSelectedSymbolIndexes();
    }

    public void setSelectedEdgeSymbols(int[] symbolIndexes) throws NoEdgeSelectedException {
        if (this.selectedEdge == null) {
            throw new NoEdgeSelectedException();
        }
        this.selectedEdge.setSelectedSymbolIndexes(symbolIndexes);
        this.repaint();
        this.selectedEdgeSymbolsChanged(symbolIndexes);
    }

    public void setSelectedEdgeTextOut(String text) throws NoEdgeSelectedException {
        if (this.selectedEdge == null) {
            throw new NoEdgeSelectedException();
        }
        this.selectedEdge.setTextOut(text);
        this.repaint();
    }

    Enumeration getInitialStates() {
        return this.initialStates.elements();
    }

    void selectedEdgeSymbolChanged(int index, boolean b) {
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            ((FsaEditListener)e.nextElement()).fsaSelectedEdgeSymbolChanged(index, b);
        }
    }

    void setStepping(boolean stepping) {
        this.tm.setStepping(stepping);
    }

    boolean tooCloseToNode(int x, int y) {
        return this.tooCloseToNode(x, y, null);
    }

    boolean tooCloseToNode(int x, int y, Node ignoreNode) {
        Enumeration enumer = this.nodes.elements();
        while (enumer.hasMoreElements()) {
            Node n = (Node)enumer.nextElement();
            if (n == ignoreNode || !n.tooClose(x, y)) continue;
            return true;
        }
        return false;
    }

    public void saveToFile(String filename) throws IOException {
        DataOutputStream dos = this.ioManager.openFileAsDataOutputStream(filename);
        Enumeration enumer = this.nodes.elements();
        dos.writeInt(this.nodes.size());
        while (enumer.hasMoreElements()) {
            ((Node)enumer.nextElement()).write(dos);
        }
        enumer = this.edges.elements();
        dos.writeInt(this.edges.size());
        while (enumer.hasMoreElements()) {
            ((Edge)enumer.nextElement()).write(dos);
        }
        dos.close();
    }

    public boolean keyDown(Event evt, int key) {
        switch (key) {
            case 27: {
                switch (this.mode) {
                    case 1: {
                        this.mode = 0;
                        this.tempEdge = null;
                        this.repaint();
                        return true;
                    }
                    case 3: {
                        this.mode = 0;
                        this.repaint();
                        return true;
                    }
                }
            }
        }
        return super.keyDown(evt, key);
    }

    void remove(Node n) {
        this.nodes.removeElement(n);
        n.removeAllEdges();
        this.repaint();
    }

    void remove(Edge e) {
        this.edges.removeElement(e);
    }

    void remove(Tourist t) {
        if (t != null && this.tracers.contains(t)) {
            this.tracers.removeElement(t);
        }
    }

    Node nodeAt(int x, int y) {
        Enumeration enumer = this.nodes.elements();
        while (enumer.hasMoreElements()) {
            Node n = (Node)enumer.nextElement();
            if (!n.inside(x, y)) continue;
            return n;
        }
        return null;
    }

    Node nodeAt(int index) {
        return (Node)this.nodes.elementAt(index);
    }

    void resumeThread() {
        if (this.tmThread != null) {
            this.tmThread.resume();
        }
    }

    void setControls(int mode) {
        int tmState = this.tm.getState();
        if (tmState == 1) {
            this.control.stepCompleted();
        } else if (tmState == 2) {
            this.control.inputAccepted();
        } else if (tmState == 3) {
            this.control.inputNotAccepted();
        }
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            Dimension d = this.size();
            this.offscreen = this.createImage(d.width, d.height);
        }
        Graphics offg = this.offscreen.getGraphics();
        offg.setColor(this.getBackground());
        offg.fillRect(0, 0, this.size().width, this.size().height);
        offg.setColor(this.getForeground());
        if (this.mode == 5) {
            Enumeration tracerEnum = this.tracers.elements();
            offg.drawImage(this.staticImage, 0, 0, this);
            while (tracerEnum.hasMoreElements()) {
                Tracer t = (Tracer)tracerEnum.nextElement();
                Graphics clipg = offg.create();
                clipg.clipRect(t.center.x - t.rad - 1, t.center.y - t.rad - 1, t.size + 4, t.size + 4);
                if (t == this.selectedTracer) continue;
                t.paint(clipg);
            }
            if (this.selectedTracer != null) {
                this.selectedTracer.paint(offg);
            }
        } else {
            Enumeration enumer = this.nodes.elements();
            while (enumer.hasMoreElements()) {
                ((Node)enumer.nextElement()).paint(offg);
            }
        }
        if ((this.mode == 1 || this.mode == 4) && this.tempEdge != null) {
            this.tempEdge.paint(offg);
        }
        if (this.mode == 3) {
            this.tempNode.paint(offg);
        }
        g.drawImage(this.offscreen, 0, 0, this);
    }

    public boolean isSelectedNodeInitialState() throws NoNodeSelectedException {
        if (this.selectedNode == null) {
            throw new NoNodeSelectedException();
        }
        return this.selectedNode.isInitialState();
    }

    void enteredRunState() {
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            ((FsaEditListener)e.nextElement()).fsaEnteredRunState();
        }
    }

    public boolean mouseUp(Event evt, int x, int y) {
        switch (this.mode) {
            case 1: 
            case 4: {
                Node n = this.nodeAt(x, y);
                if (n != null && !n.isEdgeFrom(this.selectedNode) && n != this.selectedNode) {
                    this.selectedNode.addOutEdge(this.tempEdge, n);
                    this.selectedEdge = this.tempEdge;
                    this.selectionChanged();
                } else if (this.selectedNode.inLoopRange(x, y)) {
                    this.dir.set(this.selectedNode.center.x, this.selectedNode.center.y, x, y);
                    this.tempEdge.setAngle(this.dir.getAngle() + this.angleOffset);
                    this.selectedNode.addOutEdge(this.tempEdge);
                    this.selectedEdge = this.tempEdge;
                    this.selectionChanged();
                } else {
                    this.selectedEdge = null;
                }
                if (this.selectedEdge != null) {
                    this.selectedNode.setHighlight(false);
                    this.selectedNode = null;
                    this.selectionChanged();
                }
                this.tempEdge = null;
                this.mode = 0;
                this.repaint();
                return true;
            }
            case 3: {
                if (!this.tooCloseToNode(x, y)) {
                    this.add(this.tempNode);
                    this.selectedNode = this.tempNode;
                    this.selectionChanged();
                    this.tempNode = new Node();
                    this.tempNode.setParent(this);
                    this.mode = 0;
                    this.repaint();
                }
                return true;
            }
            case 2: {
                this.mode = 0;
                return true;
            }
        }
        return super.mouseUp(evt, x, y);
    }

    public void loadFromFile(String filename) throws IOException {
        int i;
        DataInputStream dis = this.ioManager.openFileAsDataInputStream(filename);
        this.nodes.removeAllElements();
        this.edges.removeAllElements();
        this.initialStates.removeAllElements();
        this.mode = 0;
        this.po.move(0, 0);
        this.selectedNode = null;
        this.selectedEdge = null;
        int count = dis.readInt();
        for (i = 0; i < count; ++i) {
            this.add(Node.read(dis));
        }
        count = dis.readInt();
        for (i = 0; i < count; ++i) {
            Edge.read(this, dis);
        }
        dis.close();
        this.repaint();
    }

    public synchronized void addFsaEditListener(FsaEditListener fel) {
        this.fsaListeners.addElement(fel);
    }

    public void setSelectedEdgeSymbol(int index, boolean b) throws NoEdgeSelectedException {
        if (this.selectedEdge == null) {
            throw new NoEdgeSelectedException();
        }
        if (this.selectedEdge.isSymbolSet(index) != b) {
            this.selectedEdge.setSymbol(index, b);
            this.repaint();
            this.selectedEdgeSymbolChanged(index, b);
        }
    }

    Edge edgeAt(int x, int y) {
        Enumeration enumer = this.edges.elements();
        while (enumer.hasMoreElements()) {
            Edge e = (Edge)enumer.nextElement();
            if (!e.inside(x, y)) continue;
            return e;
        }
        return null;
    }

    void suspendThread() {
        if (this.tmThread != null) {
            this.tmThread.suspend();
        }
    }

    void selectedEdgeSymbolsChanged(int[] symbolIndexes) {
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            ((FsaEditListener)e.nextElement()).fsaSelectedEdgeSymbolsChanged(symbolIndexes);
        }
    }

    void selectionChanged() {
        int type = this.getSelectionType();
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            switch (type) {
                case 0: {
                    ((FsaEditListener)e.nextElement()).fsaSelectionChanged(this.selectedNode.isInitialState(), this.selectedNode.getSelectedSymbolIndex());
                    break;
                }
                case 1: {
                    ((FsaEditListener)e.nextElement()).fsaSelectionChanged(this.selectedEdge.getSelectedSymbolIndexes());
                    break;
                }
                case 2: {
                    ((FsaEditListener)e.nextElement()).fsaSelectionChanged();
                }
            }
        }
    }

    public boolean mouseDown(Event evt, int x, int y) {
        switch (this.mode) {
            case 0: {
                Node n = this.nodeAt(x, y);
                if (n != null) {
                    this.po.move(x - n.center.x, y - n.center.y);
                    if (this.selectedNode == null || this.selectedNode != n) {
                        if (this.selectedNode == null) {
                            if (this.selectedEdge != null) {
                                this.selectedEdge.setHighlight(false);
                                this.selectedEdge = null;
                            }
                        } else {
                            this.selectedNode.setHighlight(false);
                        }
                        this.selectedNode = n;
                        n.setHighlight(true);
                        this.selectionChanged();
                    }
                } else {
                    Edge e = this.edgeAt(x, y);
                    if (e != null) {
                        if (this.selectedEdge == null || this.selectedEdge != e) {
                            if (this.selectedEdge == null) {
                                if (this.selectedNode != null) {
                                    this.selectedNode.setHighlight(false);
                                    this.selectedNode = null;
                                }
                            } else if (this.selectedEdge != e) {
                                this.selectedEdge.setHighlight(false);
                            }
                            this.selectedEdge = e;
                            e.setHighlight(true);
                            this.selectionChanged();
                        }
                        if (evt.metaDown()) {
                            return this.mouseDrag(evt, x, y);
                        }
                    } else {
                        this.po.move(0, 0);
                        if (this.selectedNode != null) {
                            this.selectedNode.setHighlight(false);
                            this.selectedNode = null;
                            this.selectionChanged();
                            this.repaint();
                        } else if (this.selectedEdge != null) {
                            this.selectedEdge.setHighlight(false);
                            this.selectedEdge = null;
                            this.selectionChanged();
                            this.repaint();
                        }
                        if (evt.metaDown() && !this.tooCloseToNode(x, y)) {
                            this.mode = 3;
                            this.tempNode.setHighlight(true);
                            this.selectedNode = this.tempNode;
                            return this.mouseDrag(evt, x, y);
                        }
                        return true;
                    }
                }
                this.repaint();
                return true;
            }
        }
        return super.mouseDown(evt, x, y);
    }

    void clear() {
        this.nodes.removeAllElements();
        this.edges.removeAllElements();
        this.initialStates.removeAllElements();
        this.selectedNode = null;
        this.selectedEdge = null;
        this.po.move(0, 0);
        this.tracers.removeAllElements();
        this.repaint();
    }

    Enumeration getTourists() {
        if (!this.newTracers.isEmpty()) {
            Enumeration newOnes = this.newTracers.elements();
            while (newOnes.hasMoreElements()) {
                this.tracers.addElement(newOnes.nextElement());
            }
            this.newTracers.removeAllElements();
        }
        return this.tracers.elements();
    }

    int numTourists() {
        return this.tracers.size();
    }

    void run() {
        this.tmThread = new Thread(this.tm);
        this.tmThread.start();
    }

    public void removeComponent() {
        if (this.selectedNode != null) {
            this.selectedNode.removeAllEdges();
            this.nodes.removeElement(this.selectedNode);
            if (this.selectedNode.isInitialState()) {
                this.initialStates.removeElement(this.selectedNode);
            }
            this.selectedNode = null;
        } else if (this.selectedEdge != null) {
            this.selectedEdge.getSource().removeOutEdge(this.selectedEdge.getDestination());
            this.selectedEdge = null;
        }
        this.selectionChanged();
        this.repaint();
    }

    int runState() {
        return this.tm.getState();
    }

    void removeInitialState(Node n) {
        this.initialStates.removeElement(n);
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        switch (this.mode) {
            default: {
                break;
            }
            case 0: {
                if (evt.metaDown()) {
                    Node n = this.nodeAt(x, y);
                    if (this.selectedNode != null && n == this.selectedNode) {
                        this.mode = 2;
                        return this.mouseDrag(evt, x, y);
                    }
                    Edge e = this.edgeAt(x, y);
                    if (this.selectedEdge == null || e != this.selectedEdge) break;
                    this.mode = 4;
                    e.getSource().removeOutEdge(e.getDestination());
                    this.tempEdge = e;
                    this.selectedEdge = null;
                    this.selectedNode = e.getSource();
                    this.selectedNode.setHighlight(true);
                    if (e.isLoop()) {
                        this.dir.set(e.getSource().center, x, y);
                        double angle = this.dir.getAngle();
                        this.angleOffset = e.getAngle() - angle;
                    } else {
                        this.angleOffset = 0.0;
                    }
                    return this.mouseDrag(evt, x, y);
                }
                if (this.selectedNode == null || this.nodeAt(x, y) != this.selectedNode) break;
                this.mode = 1;
                this.tempNode.setCenter(x, y);
                this.tempEdge = new Edge(this.selectedNode, this.tempNode);
                this.tempEdge.setHighlight(true);
                return this.mouseDrag(evt, x, y);
            }
            case 1: 
            case 4: {
                this.dir.set(this.selectedNode.center, x, y);
                if (this.selectedNode.inLoopRange(x, y)) {
                    if (!this.tempEdge.isLoop()) {
                        this.tempEdge.loop();
                    }
                    this.tempEdge.setAngle(this.dir.getAngle() + this.angleOffset);
                } else {
                    Node n;
                    if (!this.tempEdge.isStraight()) {
                        this.tempEdge.straighten();
                    }
                    if ((n = this.nodeAt(x, y)) != null && !n.isEdgeFrom(this.selectedNode)) {
                        if (this.tempEdge.getDestination() != n) {
                            this.tempEdge.setDestination(n);
                        }
                    } else {
                        Point np = new Point(x, y);
                        if (this.tempEdge.getDestination() != this.tempNode) {
                            this.tempEdge.setDestination(this.tempNode);
                        }
                        this.dir.translatePoint(np, 14);
                        this.tempNode.setCenter(np);
                    }
                    this.tempEdge.update();
                }
                this.repaint();
                return true;
            }
            case 2: {
                if (this.tooCloseToNode(x - this.po.x, y - this.po.y, this.selectedNode)) break;
                this.selectedNode.setCenter(x - this.po.x, y - this.po.y);
                this.repaint();
                return true;
            }
            case 3: {
                if (this.tooCloseToNode(x, y)) break;
                this.tempNode.setCenter(x, y);
                this.repaint();
                return true;
            }
        }
        return super.mouseDrag(evt, x, y);
    }

    void enteredEditState() {
        Enumeration e = this.fsaListeners.elements();
        while (e.hasMoreElements()) {
            ((FsaEditListener)e.nextElement()).fsaEnteredEditState();
        }
    }

    public int getSelectionType() {
        if (this.selectedNode != null) {
            return 0;
        }
        return this.selectedEdge == null ? 2 : 1;
    }

    public void clearOutput() {
        this.output.clear();
    }
}

