/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import bluej.extensions.BlueJ;
import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import sum.transduktor.DestroyableFrame;
import sum.transduktor.FilenameExtensionFilter;
import sum.transduktor.FiniteStateAutomaton;
import sum.transduktor.FixedFileDialog;
import sum.transduktor.FsaControlPanel;
import sum.transduktor.FsaDisplay;
import sum.transduktor.FsaEditPanel;
import sum.transduktor.FsaOutput;
import sum.transduktor.JifPanel;
import sum.transduktor.MenuListener;
import sum.transduktor.OKDialog;
import sum.transduktor.RuleBasedLayout;
import sum.transduktor.StatusBar;

public class FSA
extends DestroyableFrame
implements MenuListener {
    FiniteStateAutomaton fsa;
    JifPanel fsaPanel;
    JifPanel displayPanel;
    JifPanel outputPanel;
    FsaEditPanel editPanel;
    FsaControlPanel controlPanel;
    FsaDisplay display;
    FsaOutput output;
    StatusBar statusBar;
    Menu fileMenu = new Menu("Datei");
    MenuItem loadFileItem = new MenuItem("Laden");
    MenuItem saveFileItem;
    MenuItem exitFileItem;

    public void menuActionPerformed(String action) {
        if (action.equals("Laden")) {
            FixedFileDialog ffd = new FixedFileDialog((Frame)this, "Lade Transduktor-Datei", 0);
            FilenameExtensionFilter fef = new FilenameExtensionFilter(".trd", true);
            ffd.setFilenameFilter(fef);
            ffd.setFile("*.trd");
            ffd.setVisible(true);
            String dir = ffd.getDirectory();
            String file = ffd.getFile();
            if (dir != null && file != null && fef.accept(new File(dir), file)) {
                if (!new File(dir + file).exists()) {
                    OKDialog.createOKDialog(dir + file + " not found!");
                } else {
                    try {
                        this.fsa.loadFromFile(dir + file);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        } else if (action.equals("Speichern")) {
            FixedFileDialog ffd = new FixedFileDialog((Frame)this, "Speichere Transduktor-Datei", 1);
            FilenameExtensionFilter fef = new FilenameExtensionFilter(".trd", true);
            ffd.setFile("*.trd");
            ffd.setVisible(true);
            String dir = ffd.getDirectory();
            String file = ffd.getFile();
            if (dir != null && file != null && fef.accept(new File(dir), file)) {
                try {
                    this.fsa.saveToFile(dir + file);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        } else if (action.equals("Beenden")) {
            this.dispose();
        }
    }

    public FSA(BlueJ pBlueJ) {
        super("Mealy-Automat - Transduktor");
        this.fileMenu.add(this.loadFileItem);
        this.saveFileItem = new MenuItem("Speichern");
        this.fileMenu.add(this.saveFileItem);
        this.exitFileItem = new MenuItem("Beenden");
        this.fileMenu.add(this.exitFileItem);
        this.addMenu(this.fileMenu);
        this.setSize(this.getToolkit().getScreenSize());
        this.addMenuListener(this);
        this.init();
        this.setVisible(true);
    }

    public void init() {
        RuleBasedLayout r = new RuleBasedLayout();
        this.editPanel = new FsaEditPanel(this);
        this.add(this.editPanel);
        this.displayPanel = new JifPanel(80);
        this.displayPanel.setLayout(new BorderLayout());
        this.display = new FsaDisplay(this);
        this.displayPanel.add("Center", this.display);
        this.add(this.displayPanel);
        this.outputPanel = new JifPanel(80);
        this.outputPanel.setLayout(new BorderLayout());
        this.output = new FsaOutput(this);
        this.outputPanel.add("Center", this.output);
        this.add(this.outputPanel);
        this.fsaPanel = new JifPanel(16);
        this.fsaPanel.setLayout(new BorderLayout());
        this.fsa = new FiniteStateAutomaton(this, this.display, this.output);
        this.fsaPanel.add("Center", this.fsa);
        this.add(this.fsaPanel);
        this.editPanel.setTargetFSA(this.fsa);
        this.fsa.addFsaEditListener(this.editPanel);
        this.statusBar = new StatusBar();
        this.add(this.statusBar);
        this.controlPanel = new FsaControlPanel(this.fsa, this.statusBar);
        this.add(this.controlPanel);
        r = new RuleBasedLayout();
        r.move(r.top(this.displayPanel), r.top(this));
        r.move(r.left(this.displayPanel), r.left(this));
        r.stretch(r.right(this.displayPanel), r.left(this.editPanel));
        r.move(r.top(this.outputPanel), r.bottom(this.displayPanel));
        r.move(r.left(this.outputPanel), r.left(this));
        r.stretch(r.right(this.outputPanel), r.left(this.editPanel));
        r.move(r.left(this.fsaPanel), r.left(this));
        r.move(r.top(this.fsaPanel), r.bottom(this.outputPanel));
        r.move(r.bottom(this.statusBar), r.bottom(this));
        r.move(r.left(this.statusBar), r.left(this));
        r.stretch(r.right(this.statusBar), r.left(this.editPanel));
        r.move(r.right(this.editPanel), r.right(this));
        r.move(r.top(this.editPanel), r.top(this));
        r.move(r.right(this.controlPanel), r.right(this));
        r.move(r.top(this.controlPanel), r.bottom(this.editPanel));
        r.stretch(r.left(this.controlPanel), r.left(this.editPanel));
        r.stretch(r.bottom(this.fsaPanel), r.top(this.statusBar));
        r.stretch(r.right(this.fsaPanel), r.left(this.editPanel));
        this.setLayout(r);
        this.repaint();
    }

    public boolean handleEvent(Event evt) {
        if (evt.id == 1002) {
            try {
                System.out.println("before the call");
                this.fsa.loadFromFile((String)evt.arg);
            }
            catch (IOException ioe) {
                System.out.println("Unable to load " + (String)evt.arg + "!");
                ioe.printStackTrace();
            }
            return true;
        }
        return super.handleEvent(evt);
    }

    public DataInputStream openFileAsDataInputStream(String filename) throws FileNotFoundException {
        DataInputStream dis = null;
        dis = new DataInputStream(new FileInputStream(filename));
        return dis;
    }

    public DataOutputStream openFileAsDataOutputStream(String filename) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(filename));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return dos;
    }
}

